/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ComparatorParameter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.Logo2;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo1;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageMemory8;

public class LinkerToLogo2
extends LinkerToLogo1 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected Memory fMessageMemory;

    public LinkerToLogo2(Logo2 hw) {
        super(hw);
    }

    public int putMessage(MessageLine[] message) throws ArrayIndexOutOfBoundsException {
        MessageMemory8 msgMemory = (MessageMemory8)((Logo)this.fHardware).getMemory("Meldetext");
        int line = this.putMessageLine(msgMemory, message[0]);
        for (int i = 1; i < message.length; ++i) {
            this.putMessageLine(msgMemory, message[i]);
        }
        return line / 4;
    }

    protected int putMessageLine(MessageMemory8 msgMemory, MessageLine msgLine) throws ArrayIndexOutOfBoundsException {
        int[] line = new int[msgMemory.getBlockSize()];
        if (msgLine.getBlockParameter() == null) {
            byte[] bytes = msgLine.getText().getBytes();
            int size = msgLine.getLength();
            line[0] = 1;
            for (int i = 0; i < size; ++i) {
                line[i + 1] = bytes[i];
            }
        } else {
            BlockParameter para = msgLine.getBlockParameter();
            Block block = para.getBlock();
            line[0] = 2;
            line[1] = this.convertToPrgLine(para.getBlock().getNumber());
            line[2] = block.getOpcode(this.fHardware, block.getNumber());
            line[3] = msgLine.getParameterItem().getParameterNumber();
        }
        return msgMemory.putMemoryBlock(line);
    }

    public Object visit(ComparatorParameter param) {
        int[] eeprom = new int[3];
        eeprom[0] = param.getProtection() ? 240 : 241;
        int temp = param.getOnThreshold().getCurrentValue();
        eeprom[1] = (temp & 0xFF00) >> 8;
        eeprom[2] = temp & 0xFF;
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[3];
        temp = param.getOffThreshold().getCurrentValue();
        eeprom[0] = 240;
        eeprom[1] = (temp & 0xFF00) >> 8;
        eeprom[2] = temp & 0xFF;
        this.putParameter(eeprom);
        int[] time = param.getTimeInterval().getParamTime().getLogoTime();
        eeprom = new int[]{240, time[0], time[1]};
        this.putParameter(eeprom);
        this.setReference(this.getFreeTimer());
        this.setReference(this.getFreeRAMorREM(param));
        this.getFreeRAMorREM(param);
        this.getFreeRAMorREM(param);
        return null;
    }

    public Object visit(MessageParameter param) {
        int[] eeprom = new int[3];
        eeprom[0] = 240;
        eeprom[1] = param.getPriority();
        if (param.isReceipt()) {
            eeprom[1] = eeprom[1] | 0x80;
        }
        eeprom[2] = this.putMessage(param.getMessage());
        this.setReference(this.putParameter(eeprom));
        this.setReference(128);
        return null;
    }

    public Object visit(Time2ProtectionParameter param) {
        int[] time = param.getHTimer().getParamTime().getLogoTime();
        int[] eeprom = new int[]{param.getProtection() ? 240 : 241, time[0], time[1]};
        this.setReference(this.putParameter(eeprom));
        time = param.getLTimer().getParamTime().getLogoTime();
        eeprom = new int[]{240, time[0], time[1]};
        this.putParameter(eeprom);
        this.setReference(this.getFreeTimer());
        this.setReference(this.getFreeRAMorREM(param));
        return null;
    }
}

